/*
    Hello World for the COMX-35
    by Marcel van Tongoren & Bill Rowe
*/

#include <nstdlib.h>
#include "comx\rca_vis_video.h"
#include "comx\rca_vis_sound.h"
#ifdef __PECOM__
#include "comx\rca_joystick.h"
#endif
#ifdef __TMC600__
#include "comx\rca_joystick.h"
#endif
#ifdef __CIDELSA__
#include "comx\rca_joystick.h"
#endif
#ifdef __COMX__
#include "comx\rca_keyboard_encoder.h"
#endif
#include "comx\rca_rand.h"
#include "comx\rca_system.h"
#ifndef __CIDELSA__
#include "comx\rca_printf.h"
#endif

#ifdef __COMX__
#define key_up 0x82
#define key_right 0x83
#define key_left 0x84
#define key_down 0x85
#define key_exit 0x71
#endif

#ifdef __PECOM__
#define key_up 0x5e
#define key_right 0x5d
#define key_left 0x5c
#define key_down 0x5b
#define key_exit 0x40
#endif

#ifdef __TMC600__
#define key_up 0xb
#define key_right 0x9
#define key_left 0x8
#define key_down 0xa
#define key_exit 0x20
#endif

#ifdef __CIDELSA__
#define key_up 0x10
#define key_right 0x40
#define key_left 0x80
#define key_down 0x20
#define key_exit 0x1
#endif

void main(){

#ifdef __CIDELSA__
static const unsigned char shape_alpha[] =
{
	0x7E,	// First byte is the '3rd' color bit for following lines one bit per line, b7 for first line
	0x00, 0xDF, 0xE8, 0xE8, 0xE8, 0xFF, 0xDF, 0x00,  //A
	0x7E,
	0x00, 0xD6, 0xE9, 0xE9, 0xE9, 0xFF, 0xFF, 0x00,  //B
	0x7E, 
	0x00, 0xD2, 0xE1, 0xE1, 0xE1, 0xFF, 0xDE, 0x00,  //C
	0x7E, 
	0x00, 0xDE, 0xE1, 0xE1, 0xE1, 0xFF, 0xFF, 0x00,  //D
	0x7E, 
	0x00, 0xE1, 0xE1, 0xE9, 0xE9, 0xFF, 0xFF, 0x00,  //E
	0x7E,
	0x00, 0xE0, 0xE0, 0xE8, 0xE8, 0xFF, 0xFF, 0x00,  //F
	0x7E,
	0x00, 0xD6, 0xE5, 0xE1, 0xE1, 0xFF, 0xDE, 0x00,  //G
	0x7E, 
	0x00, 0xFF, 0xC8, 0xC8, 0xC8, 0xFF, 0xFF, 0x00,  //H
	0x3C, 
	0x00, 0x00, 0xE1, 0xFF, 0xFF, 0xE1, 0x00, 0x00,  //I
	0x7E, 
	0x00, 0xFE, 0xFF, 0xC1, 0xC1, 0xC1, 0xC2, 0x00,  //J
	0x3E, 
	0x00, 0x00, 0xE1, 0xD2, 0xCC, 0xFF, 0xFF, 0x00,  //K
	0x3E, 
	0x00, 0x00, 0xC1, 0xC1, 0xC1, 0xFF, 0xFF, 0x00,  //L
	0x7E, 
	0x00, 0xFF, 0xD0, 0xC8, 0xD0, 0xFF, 0xFF, 0x00,  //M
	0x7E, 
	0x00, 0xFF, 0xC4, 0xC8, 0xD0, 0xFF, 0xFF, 0x00,  //N
	0x7E, 
	0x00, 0xDE, 0xE1, 0xE1, 0xE1, 0xFF, 0xDE, 0x00,  //O
	0x7E, 
	0x00, 0xD0, 0xE8, 0xE8, 0xE8, 0xFF, 0xFF, 0x00,  //P
	0x7E, 
	0x00, 0xDE, 0xE1, 0xE7, 0xE1, 0xFF, 0xDE, 0x00,  //Q
	0x7E, 
	0x00, 0xD1, 0xEA, 0xEC, 0xE8, 0xFF, 0xFF, 0x00,  //R
	0x7E, 
	0x00, 0xE6, 0xEF, 0xE9, 0xE9, 0xF9, 0xD1, 0x00,  //S
	0x7E, 
	0x00, 0xE0, 0xE0, 0xFF, 0xFF, 0xE0, 0xE0, 0x00,  //T
	0x7E, 
	0x00, 0xFE, 0xC1, 0xC1, 0xC1, 0xFF, 0xFE, 0x00,  //U
	0x7E, 
	0x00, 0xF0, 0xCC, 0xC3, 0xCF, 0xFC, 0xF0, 0x00,  //V
	0xFF, 
	0xF0, 0xCC, 0xC3, 0xCC, 0xC3, 0xCF, 0xFC, 0xF0,  //W
	0x7E, 
	0x00, 0xF3, 0xD4, 0xC8, 0xD4, 0xF3, 0xF3, 0x00,  //X
	0x7E,
	0x00, 0xE0, 0xD0, 0xCF, 0xDF, 0xF0, 0xE0, 0x00,  //Y
	0x7E,
	0x00, 0xF1, 0xF1, 0xE9, 0xE5, 0xE3, 0xE3, 0x00,  //Z
};

static const unsigned char shape_numbers[] =
{
	0x00,	
	0x5E, 0x61, 0x61, 0x61, 0x5E, 0x00, 0x00, 0x00,	 //0
	0x00, 
	0x41, 0x7F, 0x61, 0x51, 0x41, 0x00, 0x00, 0x00,  //1
	0x00, 
	0x51, 0x69, 0x65, 0x65, 0x53, 0x00, 0x00, 0x00,  //2
	0x00, 
	0x56, 0x69, 0x69, 0x61, 0x61, 0x00, 0x00, 0x00,  //3
	0x00, 
	0x44, 0x7F, 0x64, 0x54, 0x4C, 0x00, 0x00, 0x00,  //4
	0x00, 
	0x66, 0x69, 0x69, 0x69, 0x72, 0x00, 0x00, 0x00,  //5
	0x00, 
	0x66, 0x69, 0x69, 0x69, 0x5E, 0x00, 0x00, 0x00,  //6
	0x00, 
	0x70, 0x68, 0x64, 0x63, 0x60, 0x00, 0x00, 0x00,  //7
	0x00, 
	0x56, 0x69, 0x69, 0x69, 0x56, 0x00, 0x00, 0x00,  //8
	0x00, 
	0x5E, 0x69, 0x69, 0x69, 0x51, 0x00, 0x00, 0x00,  //9
	0x00, 
};

static const unsigned char shape_space[] =
{
	0x00,	
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	 //space
};
#else
static const unsigned char shapes[] =
{
	97, // First byte is the character to shape followed by 9 bytes for the shape
	0x00, 0xcc, 0xde, 0xed, 0xff, 0xf3, 0xed, 0xe1, 0x00,
	98, // next character to shape
	0x00, 0x8c, 0x9e, 0xad, 0xbf, 0xb3, 0xad, 0xa1, 0x00,
	99,
	0x00, 0x00, 0xcc, 0xde, 0xff, 0xde, 0xcc, 0x00, 0x00,
};
#endif

#ifdef __CIDELSA__
	unsigned int vidmem=0xfc10;
#else
	unsigned int vidmem=0xf800;
#endif

	unsigned char key;
	unsigned int loop;
	unsigned int oldbkcolor;

	disableinterrupt();
    setvideobase(vidmem);

	oldbkcolor = bgcolor(0);
#ifndef __TMC600__
	textcolordefinition(3);
	monochrome(0);
#ifdef __CIDELSA__
	shapechar(shape_space, 0x0001, 0x0);
	shapechar(shape_space, 0x2001, 0x0);
	shapechar(shape_numbers, 0x300A, 0x40);
	shapechar(shape_alpha, 0x411A, 0x0);
	shapechar(shape_space, 0x8001, 0x0);
	shapechar(shape_space, 0xA001, 0x0);
	shapechar(shape_numbers, 0xB00A, 0x80);
	shapechar(shape_alpha, 0xC11A, 0xa0);
#else
	shapecolor(0x20, 0x5f, 2);
	shapechar(shapes, 3);
#endif
#else
	textcolor(7);
#endif

#ifdef __CIDELSA__
    vidclr(0xf800,27*40);
	vidstrcpy(vidmem, "HELLO WORLD");
	vidstrcpy(vidmem + 4, "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
	vidstrcpy(vidmem + 6, "0 1 2 3 4 5 6 7 8 9");
	textcolor(1);
	vidstrcpy(vidmem + 8, "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
	vidstrcpy(vidmem + 10, "0 1 2 3 4 5 6 7 8 9");
	vidmem += 2;
#else
    vidclr(vidmem,24*40);
	vidstrcpy(vidmem, "HELLO ");
	textcolor(1);
	vidstrcpy(vidmem+6, "WORLD");
	vidmem = 0xf828;
#endif

#ifdef __TMC600__
	setcolor(0,3);
#endif
	loop = 1;

	while (1){
#ifdef __CIDELSA__
		key = get_stick();
		if (get_trigger() != 0)
			key = 1;
#else
		key = getkey();
#endif
		switch (key){
			case key_up:
				vidstrcpy(vidmem,"UP   ");
				generatetone(80,5,7);
			break;
			case key_right:
				vidstrcpy(vidmem,"RIGHT");
				generatenoise(2,7);
			break;
			case key_left:
				vidstrcpy(vidmem,"LEFT ");
				generatenoise(6,7);
			break;
			case key_down:
				vidstrcpy(vidmem,"DOWN ");
				generatetone(80,7,7);
			break;
			case key_exit:  // Q or space
				loop = 0;
			break;	
			default:
			break;			
		}
		if (kbhit() == 0)
		{
			generatetone(0, 0, 0);
			generatenoise(0,0);
		}
		if (loop == 0)  break;
	}

	while (kbhit() == 1)
	{
	}

	loop = 1;
	vidmem = 0xfa00;
	vidchar(vidmem,'X');
	while (1){
#ifdef __CIDELSA__
		key = get_stick();
		if (get_trigger() != 0)
			key = 1;
#else
		key = getkey();
#endif
		switch (key){
			case key_up:
				vidchar(vidmem,' ');
#ifdef __CIDELSA__
				vidmem--;
#else
				vidmem = vidmem - 40;
#endif
				vidchar(vidmem,'X');
			break;
			case key_right:
				vidchar(vidmem,' ');
#ifdef __CIDELSA__
				vidmem = vidmem - 40;
#else
				vidmem++;
#endif
				vidchar(vidmem,'X');
			break;
			case key_left:
				vidchar(vidmem,' ');
#ifdef __CIDELSA__
				vidmem = vidmem + 40;
#else
				vidmem--;
#endif
				vidchar(vidmem,'X');
			break;
			case key_down:
				vidchar(vidmem,' ');
#ifdef __CIDELSA__
				vidmem++;
#else
				vidmem = vidmem + 40;
#endif
				vidchar(vidmem,'X');
			break;
			case key_exit:  // Q or space
				loop = 0;
			break;	
			default:
			break;			
		}
		if (loop == 0)  break;
	}

	enableinterrupt();
    vidclr(vidmem,24*40);
#ifndef __CIDELSA__
	gotoxy(0,0);
    printf("HELLO WORLD!");
	gotoxy(20,0);
    printf("20,0");
	gotoxy(0,20);
    printf("0,20");
	gotoxy(10,10);
    printf("10,10");

	printf(" %i",rand());
	printf(" %i",rand());
	printf(" %i",rand());
	printf(" %i",rand());
	printf(" %i",rand());
#endif
}

#include <nstdlib.c>
